<?php
// admin/super_reset.php
require_once "../config/db.php"; 

// CONFIGURA AQUÍ TU NUEVA CLAVE
$nueva_clave = 'admin123'; // <--- CAMBIA ESTO POR LA QUE TU QUIERAS
$email_admin = 'admin@jfd.com'; // <--- TU CORREO DE ADMIN

try {
    // Generamos el hash seguro
    $hash = password_hash($nueva_clave, PASSWORD_DEFAULT);

    // Preparamos la actualización
    $sql = "UPDATE users SET password_hash = :hash WHERE email = :email";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'hash' => $hash,
        'email' => $email_admin
    ]);

    if ($stmt->rowCount() > 0) {
        echo "<h1 style='color:green;'>✅ ¡Éxito! Contraseña actualizada.</h1>";
        echo "<p>Tu nueva clave es: <b>$nueva_clave</b></p>";
        echo "<a href='login.php'>Ir al Login</a>";
    } else {
        echo "<h1 style='color:orange;'>⚠️ No se hicieron cambios.</h1>";
        echo "<p>Revisa si el correo <b>$email_admin</b> es el mismo que está en tu base de datos.</p>";
    }

} catch (PDOException $e) {
    echo "<h1 style='color:red;'>❌ Error de DB:</h1> " . $e->getMessage();
}
?>